<?php
// DB connection settings
$servername = 'localhost';
$username   = 'gdhhsxmy_chcenterthennala';
$password   = 'chcenterthennala';
$dbname     = 'gdhhsxmy_chcenterthennala';

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die('Connection failed: ' . $conn->connect_error);
}

function sanitize($conn, $data)
{
    return htmlspecialchars($conn->real_escape_string(trim($data)));
}

// Get ID for edit (0 or empty means new)
$id = isset($_POST['id']) ? (int) $_POST['id'] : 0;

$name   = sanitize($conn, $_POST['name']);
$age    = (int) $_POST['age'];
$gender = sanitize($conn, $_POST['gender']);
$phone  = sanitize($conn, $_POST['phone']);

function processCheckboxGroup($conn, $postArrayName, $otherTextName, $othersValue)
{
    $items     = $_POST[$postArrayName] ?? [];
    $otherText = sanitize($conn, $_POST[$otherTextName] ?? '');

    $filtered = array_filter($items, function ($v) use ($othersValue) {
        return $v != $othersValue;
    });

    return [
        'list'  => implode(',', $filtered),
        'other' => in_array($othersValue, $items) && $otherText != '' ? $otherText : '',
    ];
}

$diseaseData    = processCheckboxGroup($conn, 'diseases', 'other_disease', 'മറ്റുള്ളത്');
$activitiesData = processCheckboxGroup($conn, 'activities', 'other_activity', 'മറ്റ്');
$exerciseData   = processCheckboxGroup($conn, 'exercise_types', 'other_exercise', 'മറ്റുള്ളത്');

$diseases      = $diseaseData['list'];
$other_disease = $diseaseData['other'];

$activities     = $activitiesData['list'];
$other_activity = $activitiesData['other'];

$exercise_types = $exerciseData['list'];
$other_exercise = $exerciseData['other'];

$med_use          = sanitize($conn, $_POST['med_use']);
$med_list         = sanitize($conn, $_POST['med_list']);
$hospital_visit   = sanitize($conn, $_POST['hospital_visit']);
$hospital_details = sanitize($conn, $_POST['hospital_details']);

// Check for duplicate on insert only (skip for update)
if ($id == 0) {
    $checkStmt = $conn->prepare('SELECT COUNT(*) FROM health_form_submissions WHERE name = ? AND phone = ?');
    $checkStmt->bind_param('ss', $name, $phone);
    $checkStmt->execute();
    $checkStmt->bind_result($count);
    $checkStmt->fetch();
    $checkStmt->close();

    if ($count > 0) {
        // Duplicate found
        $success  = false;
        $errorMsg = 'ഈ പേര്, മൊബൈൽ നമ്പർ ഇതിനകം രജിസ്റ്റർ ചെയ്തിട്ടുണ്ട്.';
    }
}
$editmode = 0;

if (!isset($success) || $success != false) {
    if ($id > 0) {
        // Update existing record
        $stmt = $conn->prepare('UPDATE health_form_submissions SET 
            name=?, age=?, gender=?, phone=?, 
            diseases=?, other_disease=?, 
            med_use=?, med_list=?, 
            hospital_visit=?, hospital_details=?, 
            activities=?, other_activity=?, 
            exercise_types=?, other_exercise=? 
            WHERE id=?');

        $stmt->bind_param(
            'sissssssssssssi',
            $name,
            $age,
            $gender,
            $phone,
            $diseases,
            $other_disease,
            $med_use,
            $med_list,
            $hospital_visit,
            $hospital_details,
            $activities,
            $other_activity,
            $exercise_types,
            $other_exercise,
            $id
        );

        $success = $stmt->execute();
        $stmt->close();
        $editmode = 1;
    } else {
        // Insert new record
        $stmt = $conn->prepare('INSERT INTO health_form_submissions (
            name, age, gender, phone, 
            diseases, other_disease, 
            med_use, med_list, 
            hospital_visit, hospital_details, 
            activities, other_activity, 
            exercise_types, other_exercise
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)');

        $stmt->bind_param(
            'sissssssssssss',
            $name,
            $age,
            $gender,
            $phone,
            $diseases,
            $other_disease,
            $med_use,
            $med_list,
            $hospital_visit,
            $hospital_details,
            $activities,
            $other_activity,
            $exercise_types,
            $other_exercise
        );

        $success = $stmt->execute();
        $stmt->close();
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="ml">
<head>
    <meta charset="UTF-8" />
    <title>ഫോം സമർപ്പണം</title>
    <link rel="icon" href="ch centre_page-0001.jpg" type="image/jpeg">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        /* Make modal bigger on all screens */
        .modal-dialog {
            max-width: 700px;
        }
        /* On mobile, make it full width */
        @media (max-width: 576px) {
            .modal-dialog {
                width: 95% !important;
                max-width: 95% !important;
                margin: 10px auto;
            }
            .modal-body {
                font-size: 1.3rem;
            }
        }
        /* Style the message text */
        .modal-body .message-text {
            text-align: center;
            font-weight: bold;
            font-size: 1.6rem;
        }
    </style>
</head>
<body>

<div class="modal fade" id="submissionModal" tabindex="-1" aria-labelledby="submissionLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header <?php echo ($success) ? 'bg-success' : 'bg-danger'; ?> text-white">
        <h5 class="modal-title" id="submissionLabel">
          <?php echo ($success) ? '✅ സമർപ്പണം വിജയിച്ചു' : '❌ പിഴവ്'; ?>
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="message-text">
        <?php
          if ($success && $editmode == 0) {
              echo 'നിങ്ങളുടെ ആരോഗ്യ വിവരങ്ങൾ വിജയകരമായി സമർപ്പിച്ചു. നന്ദി!';
          } elseif ($success && $editmode == 1) {
              echo 'നിങ്ങളുടെ ആരോഗ്യ വിവരങ്ങൾ പുതുക്കിയിരിക്കുന്നു.';
          } else {
              echo isset($errorMsg) ? $errorMsg : 'സംഭവിച്ചത് ഒരു പിശക്. ദയവായി വീണ്ടും ശ്രമിക്കുക.';
          }
?>
        </div>
      </div>
      <div class="modal-footer">
          <?php if ($editmode == 1) { ?>
             <a href="view.php" class="btn btn-success">ലിസ്റ്റിലേക്ക് മടങ്ങുക</a>
          <?php } else { ?>
             <a href="index.php" class="btn btn-secondary">പുതിയത് സമർപ്പിക്കുക</a>
          <?php } ?>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
  window.onload = function() {
    var modal = new bootstrap.Modal(document.getElementById('submissionModal'));
    modal.show();
  };
</script>
</body>
</html>
