<?php
// DB connection
$servername = 'localhost';
$username   = 'gdhhsxmy_chcenterthennala';
$password   = 'chcenterthennala';
$dbname     = 'gdhhsxmy_chcenterthennala';

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die('Connection failed: ' . $conn->connect_error);
}

// Pagination settings
$limit  = 10;
$page   = isset($_GET['page']) && is_numeric($_GET['page']) ? (int) $_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Total records count
$resultTotal = $conn->query('SELECT COUNT(*) AS total FROM health_form_submissions WHERE status=0');
$totalRows   = $resultTotal->fetch_assoc()['total'];
$totalPages  = ceil($totalRows / $limit);

// Fetch records for current page
$stmt = $conn->prepare('SELECT * FROM health_form_submissions WHERE status=0 ORDER BY id DESC LIMIT ? OFFSET ?');
$stmt->bind_param('ii', $limit, $offset);
$stmt->execute();
$result = $stmt->get_result();

function safe($str)
{
    return htmlspecialchars($str);
}
?>

<!DOCTYPE html>
<html lang="ml">
<head>
    <meta charset="UTF-8" />
    <title>ആരോഗ്യ ഫോം - വിശദാംശങ്ങൾ</title>
    <link rel="icon" href="ch centre_page-0001.jpg" type="image/jpeg">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />

    <style>
      /* Remove Bootstrap container padding/margin by using container-fluid and p-0 */
      body, html {
        margin: 0;
        padding: 0;
        overflow-x: hidden; /* avoid horizontal scroll anywhere */
      }
      .container-fluid {
        padding-left: 0 !important;
        padding-right: 0 !important;
        max-width: 100% !important;
      }

      td, th {
        vertical-align: middle !important;
      }
      table th, table td {
        white-space: normal;
        word-wrap: break-word;
        font-size: 12px;
            padding: 2px;
      }
      .table-responsive {
        width: 100%;
        overflow: visible; /* no horizontal scroll */
        padding-left: 0;
        padding-right: 0;
        margin-left: 0;
        margin-right: 0;
      }
      @media (max-width: 768px) {
        table th, table td {
            font-size: 12px;
            padding: 2px;
        }
        table {
            table-layout: auto;
        }
      }
      footer {
        margin-top: 250px;
        padding: 15px 10px;
        background-color: #f3f3fb;
        text-align: center;
        border-top: 1px solid #ccc;
        border-radius: 0 0 12px 12px;
        font-size: 16px;
        font-weight: bold;
        width: 100vw;
        box-sizing: border-box;
        overflow-x: hidden;
      }
      footer span {
        background: linear-gradient(90deg, #ff6a00, #ee0979, #00c3ff);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        display: inline-block;
        margin-right: 10px;
        white-space: nowrap;
      }
      footer img {
        height: 40px;
        vertical-align: middle;
        max-width: 100%;
        height: auto;
      }
    </style>
</head>
<body>
<div class="container-fluid my-5 p-0">
    <h3 class="mb-4 px-3">ആരോഗ്യ ഫോം സമർപ്പണങ്ങളുടെ വിശദാംശങ്ങൾ</h3>
    <p class="text-muted px-3">ആകെ എൻട്രികൾ: <strong><?= $totalRows ?></strong></p>
    <div class="px-3 mb-3">
      <a href="export_all_csv.php" class="btn btn-success">ഡൗൺലോഡ് ചെയ്യുക</a>
    </div>

    <div class="table-responsive px-3">
        <table class="table table-bordered table-striped table-sm align-middle">
            <thead class="table-primary text-center">
                <tr>
                    <th>ID</th>
                    <th>പേര്</th>
                    <th>വയസ്സ്</th>
                    <th>ലിംഗം</th>
                    <th>മൊബൈൽ നമ്പർ</th>
                    <th>രോഗങ്ങൾ</th>
                    <th>മറ്റ് രോഗം</th>
                    <th>മരുന്ന് ഉപയോഗം</th>
                    <th>മരുന്നുകളുടെ പേര്/തരം</th>
                    <th>ആശുപത്രിയിൽ പോയി (6 മാസം)</th>
                    <th>ആശുപത്രി വിശദാംശങ്ങൾ</th>
                    <th>പ്രതിരോധ പ്രവർത്തനങ്ങൾ</th>
                    <th>മറ്റ് പ്രവർത്തനം</th>
                    <th>വ്യായാമം</th>
                    <th>മറ്റ് വ്യായാമം</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result->num_rows > 0): $serial = $offset + 1; ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td class="text-center"><?= $serial ?></td>
                        <td><?= safe($row['name']) ?></td>
                        <td class="text-center"><?= safe($row['age']) ?></td>
                        <td><?= safe($row['gender']) ?></td>
                        <td><?= safe($row['phone']) ?></td>
                        <td><?= safe($row['diseases']) ?></td>
                        <td><?= safe($row['other_disease']) ?></td>
                        <td><?= safe($row['med_use']) ?></td>
                        <td><?= safe($row['med_list']) ?></td>
                        <td><?= safe($row['hospital_visit']) ?></td>
                        <td><?= safe($row['hospital_details']) ?></td>
                        <td><?= safe($row['activities']) ?></td>
                        <td><?= safe($row['other_activity']) ?></td>
                        <td><?= safe($row['exercise_types']) ?></td>
                        <td><?= safe($row['other_exercise']) ?></td>
                    </tr>
                    <?php $serial++; endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="15" class="text-center">റെക്കോർഡുകൾ കാണാനില്ല</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if ($totalRows > 0): ?>
    <nav>
      <ul class="pagination justify-content-center px-3">
        <?php if ($page > 1): ?>
          <li class="page-item"><a class="page-link" href="?page=1">ആദ്യത്തെ</a></li>
          <li class="page-item"><a class="page-link" href="?page=<?= $page - 1 ?>">മുമ്പത്തെ</a></li>
        <?php endif; ?>

        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
          <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
            <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
          </li>
        <?php endfor; ?>

        <?php if ($page < $totalPages): ?>
          <li class="page-item"><a class="page-link" href="?page=<?= $page + 1 ?>">അടുത്തത്</a></li>
          <li class="page-item"><a class="page-link" href="?page=<?= $totalPages ?>">അവസാനത്തെ</a></li>
        <?php endif; ?>
      </ul>
    </nav>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<footer>
    <span>Powered by</span>
    <a href="https://workmateinfotech.com" target="_blank">
      <img src="https://workmateinfotech.com/images/Workmate_Infotech_Private_Limited____Logo_1_-0_1__1_-removebg-preview%201%20(2).png" alt="Workmate Infotech Logo">
    </a>
</footer>
</body>
</html>

<?php
$stmt->close();
$conn->close();
?>
