<?php




function hashCalculate($salt, $input)
{
    /* Columns used for hash calculation, Donot add or remove values from $hash_columns array */
    $hash_columns = ['address_line_1', 'address_line_2', 'amount', 'api_key', 'city', 'country', 'currency', 'description', 'email', 'mode', 'name', 'order_id', 'phone', 'return_url', 'state', 'udf1', 'udf2', 'udf3', 'udf4', 'udf5', 'zip_code',];
    /*Sort the array before hashing*/
    sort($hash_columns);

    /*Create a | (pipe) separated string of all the $input values which are available in $hash_columns*/
    $hash_data = $salt;

    foreach ($hash_columns as $column) {
        if (isset($input[$column])) {
            if (strlen($input[$column]) > 0) {
                $hash_data .= '|' . trim($input[$column]);
            }
        }
    }

    $hash = strtoupper(hash('sha512', $hash_data));

    return $hash;
}


require('../lib/dbclass.php');
error_reporting(1);





function api_call($final_data, $order_id)
{
    // URL to send the POST request to
    $url = 'https://pgbiz.omniware.in/v2/paymentstatus';

    // Data to send in the POST request
    $data = [
        'hash'     => $final_data,
        'api_key'  => '1a8d0e55-afaa-45f1-9c47-b75868edcb9e',
        'order_id' => $order_id,
    ];

    // Initialize cURL session
    $ch = curl_init();

    // Set cURL options for POST request
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);  // Set method to POST
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));  // Send data in POST body
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);  // To return the response as a string

    // Execute the cURL request and get the response
    $result = curl_exec($ch);



    // Check for errors
    if (curl_errno($ch)) {
        //echo 'Curl error: ' . curl_error($ch);
    } else {
        // Process the response (e.g., decode JSON if it's JSON formatted)
        //echo "Response from the server: " . $response;
    }

    // Close the cURL session
    curl_close($ch);



    // Decode the JSON data into a PHP associative array
    $data = json_decode($result, true);

    $response_message = '';

    // Access the response_message from the first item in the "data" array
    $response_message = $data['data'][0]['response_message'];




    if ($response_message == 'SUCCESS') {
        if ($data['data'][0]['bank_ref_id'] != '') {
            $Transaction_id = $data['data'][0]['bank_ref_id'];
        } else {
            $Transaction_id = $data['data'][0]['transaction_id'];
        }



        $order_id        = $data['data'][0]['order_id'];
        $order_time      = new DateTime($data['data'][0]['payment_datetime']);
        $order_date_time = $order_time->format('Y-m-d H:i:s');

        // Update query
        updateQuery("UPDATE tbl_transaction 
                         SET Transid='$Transaction_id', 
                             Received=Amount, 
                             is_Razor_payment_gateway=2, 
                             dateadded='$order_date_time' 
                         WHERE orderid='$order_id'");
    } else {
        // Update query
        updateQuery("UPDATE tbl_transaction 
                         SET 
                             Received=0
                              WHERE orderid='$order_id'");
    }
}



// The API URL
$url = 'https://chcentertirur.in/API/checkstatusomni.php';

// Use cURL to fetch the data from the API
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
$response = curl_exec($ch);
curl_close($ch);

// Decode the JSON response
$data = json_decode($response, true);


// Check if the data is valid and loop through the result
if ($data) {
    $salt    = '7f850b261dfa7105ce670612a350e6c2d3494f5c'; //Pass your SALT here
    $api_key = '1a8d0e55-afaa-45f1-9c47-b75868edcb9e'; //Pass your API KEY here



    foreach ($data['data'] as $index => $item) {
        $order_id = $item['orderid'];
        //$order_id = '6974064';
        $pendingorders = ['order_id' => $order_id,'api_key' => $api_key];
        $hash          = hashCalculate($salt, $pendingorders);
        $pendingorders = $hash;
        api_call($pendingorders, $order_id);
    }
}
