<?php
require_once('lib/dbclass.php');
$course  = ['' => 'Select', 1 => '12th student', '12th completed', 'Repeater', 'Rerepeater', 'Other'];
$state   = ['' => 'Select','Kerala' => 'Kerala','Tamilnadu' => 'Tamilnadu'];
$referal = get_option('tbl_referal', 'name');

// Get districts for all states (pre-load all possible options)
$districts_Kerala = [
    'Thiruvananthapuram', 'Kollam', 'Pathanamthitta', 'Alappuzha', 'Kottayam', 'Idukki',
    'Ernakulam', 'Thrissur', 'Palakkad', 'Malappuram', 'Kozhikode', 'Wayanad', 'Kannur', 'Kasaragod',
];

$districts_Tamilnadu = [
    'Ariyalur', 'Chennai', 'Coimbatore', 'Cuddalore', 'Dharmapuri', 'Dindigul', 'Erode', 'Kanchipuram', 'Kanyakumari',
    'Karur', 'Krishnagiri', 'Madurai', 'Nagapattinam', 'Namakkal', 'Perambalur', 'Pudukkottai', 'Ramanathapuram', 'Salem',
    'Sivagangai', 'Tenkasi', 'Thanjavur', 'Theni', 'Thoothukudi', 'Tiruchirappalli', 'Tirunelveli', 'Tiruppur', 'Vellore',
    'Villupuram', 'Virudhunagar', 'Chengalpattu', 'Kallakurichi', 'Tiruvallur', 'Tirupattur', 'Ranipet', 'Ariyalur', 'Nilgiris',
    'Tiruchirapalli', 'Kanchipuram',
];
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>NEET GALA INDIA EXAM REGISTRATION -2025</title>
    <link rel="shortcut icon" href="logo.png" type="image/x-icon" sizes="16x16">
    <link rel="stylesheet" href="style.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"></script>
    <script src="cropperjs/dist/cropper.js"></script>
    <link rel="stylesheet" href="cropperjs/dist/cropper.css">

    <style>
        img {
            display: block;
            max-width: 100%;
        }

        .preview {
            overflow: hidden;
            width: 160px;
            height: 160px;
            margin: 10px;
            border: 1px solid red;
        }

        .reg_container {
            max-width: 900px;
            margin: 0 auto;
            padding: 20px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .modal-content {
            max-width: 100%;
        }

        .modal-body img {
            max-width: 100%;
        }

        @media (max-width: 768px) {
            .reg_container {
                padding: 10px;
            }

            .modal-content {
                width: 90%;
            }
        }

        @media (max-width: 576px) {
            .form-group {
                margin-bottom: 10px;
            }

            .modal-content {
                width: 95%;
            }
        }
        
         /* Modal Styling */

/* Modal container styling */
/* Modal container styling */
#spinnerModal {
    display: none;  /* Initially hidden */
    position: fixed;  /* Use fixed positioning to keep it centered in the viewport */
    top: 80%;  /* Position it in the vertical center */
    left: 50%;  /* Position it in the horizontal center */
    transform: translate(-50%, -50%);  /* Adjust to truly center */
    z-index: 1051;  /* Ensure it stays on top */
    width: 250px;  /* Optional: set a width for the modal */
    padding: 20px;
    min-height: 200px;  /* Optional: Ensure the modal has a minimum height */
}

/* Modal content styling */
#spinnerModal .modal-content {
    background: linear-gradient(to right, var(--bs-white), #feb47b); /* White to orange gradient */
    border-radius: 10px; /* Rounded corners */
    padding: 20px;
    text-align: center;
    border: 3px solid #FF6F61; /* Border with a complementary color */
}

/* Multi-colored Spinner customization */
.spinner-border {
    width: 4rem; /* Adjust size of the spinner */
    height: 4rem; /* Adjust size of the spinner */
    border-width: 0.4rem; /* Thinner border for the spinner */
    border-radius: 50%; /* Ensure the spinner is round */
    border-top: 4px solid transparent;
    border-right: 4px solid transparent;
    border-bottom: 4px solid transparent;
    border-left: 4px solid transparent;
    border-top-color: #FF5733; /* First color */
    border-right-color: #33FF57; /* Second color */
    border-bottom-color: #3357FF; /* Third color */
    border-left-color: #FF33A8; /* Fourth color */
    animation: multiColorSpin 2s infinite linear;
}

/* Custom spinner animation */
@keyframes multiColorSpin {
    0% {
        transform: rotate(0deg);
        border-top-color: #FF5733; /* First color */
        border-right-color: #33FF57; /* Second color */
        border-bottom-color: #3357FF; /* Third color */
        border-left-color: #FF33A8; /* Fourth color */
    }
    25% {
        transform: rotate(90deg);
        border-top-color: #33FF57; /* Second color */
        border-right-color: #3357FF; /* Third color */
        border-bottom-color: #FF33A8; /* Fourth color */
        border-left-color: #FF5733; /* First color */
    }
    50% {
        transform: rotate(180deg);
        border-top-color: #3357FF; /* Third color */
        border-right-color: #FF33A8; /* Fourth color */
        border-bottom-color: #FF5733; /* First color */
        border-left-color: #33FF57; /* Second color */
    }
    75% {
        transform: rotate(270deg);
        border-top-color: #FF33A8; /* Fourth color */
        border-right-color: #FF5733; /* First color */
        border-bottom-color: #33FF57; /* Second color */
        border-left-color: #3357FF; /* Third color */
    }
    100% {
        transform: rotate(360deg);
        border-top-color: #FF5733; /* First color */
        border-right-color: #33FF57; /* Second color */
        border-bottom-color: #3357FF; /* Third color */
        border-left-color: #FF33A8; /* Fourth color */
    }
}

/* Text inside the modal */
#spinnerModal .modal-body p {
    font-size: 16px; /* Smaller font size */
    color: black; /* White text color */
    margin-top: 10px;
    font-weight: bold;
}

#spinnerModal .modal-body {
    padding: 20px 15px;
}

/* Optional: Change backdrop color */
.modal-backdrop {
    z-index: 1040 !important; /* Ensure the backdrop stays behind the spinner */
    background-color: rgba(0, 0, 0, 0.5); /* Slightly dark backdrop */
}



    </style>
</head>

<body>
     <div class="img-container" style=" display: flex; justify-content: center; align-items: center; margin-top: 4dvh;">
        <img src="LandingPage-02.jpg" alt="" srcset="" style="width: auto; max-height:600px">
</div>
    <div class="reg_container">
        <h4 class="text-center mb-4">NEET GALA INDIA EXAM REGISTRATION -2025</h4>
        <p class="indi text-center">"<span>*</span>" Indicates required fields</p>
        
        

        <form action="payments/index.php" method="post" enctype="multipart/form-data">
           
            <div class="row">
                <div class="col-12">
                    <label for="name">Full Name<span>*</span></label><br>
                    <input type="text" id="name" name="name" maxlength="30" class="form-control" required>
                </div>

                <div class="col-12 col-md-6">
                    <label for="mobile">Mobile Number<span>*</span></label><br>
                    <input type="text" id="mobile" name="mobile" pattern="^[6-9]\d{9}$" class="form-control" required placeholder="Enter 10-digit mobile number">
                </div>

                <div class="col-12 col-md-6">
                    <label>Course <span>*</span></label><br>
                    <select name="course" required id="course" class="form-control">
                        <?php echo array_options($course, 0); ?>
                    </select>
                </div>

                <div class="col-12">
                    <label for="school">Institution/ School<span>*</span></label><br>
                    <input type="text" id="school" name="school" maxlength="250" class="form-control" required>
                </div>

                <div class="col-12 col-md-6">
                    <label for="Country">Country<span>*</span></label><br>
                    <input type="text" id="Country" name="Country" value="India" class="form-control" disabled required maxlength="200">
                </div>

                <div class="col-12 col-md-6">
                    <label>State <span>*</span></label><br>
                    <select name="state" required id="state" class="form-control" onchange="updateDistricts()">
                        <?php echo array_options($state, 0); ?>
                    </select>
                </div>

                <div class="col-12">
                    <label>District <span>*</span></label><br>
                    <select name="district" required id="district" class="form-control">
                        <option value="">Select</option>
                    </select>
                </div>

                <div class="col-12">
                    <label for="neetscore">Previous Year NEET Score</label><br>
                    <input type="number" id="neetscore" name="neetscore" step="0.01" maxlength="200" class="form-control" value="0" >
                </div>

                <div class="col-12">
                    <label>Referral Code</label><br>
                    <select name="referal"  id="referal" class="form-control">
                        <?php echo array_options($referal, 0); ?>
                    </select>
                </div>

                <div class="col-12">
                    <label class="form-label" for="imageInput">Photo Upload</label>
                    <input type="file" id="imageInput" name="image" class="form-control" autocomplete="off" required />
                    <span style="color:grey;font-size:12px">*Only Upload (JPEG,JPG,PNG) format file</span>
                    <input type="hidden" id="croppedImage" name="croppedImage">
                </div>

               

<div class="col-6">
    <button type="submit" id="submitButton" class="btn btn-primary w-100">Submit</button>
</div>

<!-- Modal for Spinner -->
<div id="spinnerModal" class="modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body text-center">
                <div class="spinner-border" role="status">
                    <span class="visually-hidden">Processing...</span>
                </div>
                <p>Processing Please Wait...</p>
            </div>
        </div>
    </div>
</div>


            </div>
        </form>
    </div>

    <!-- Modal for Image Crop -->
<head>
    <style>
        /* Custom modal size */
        .modal-dialog {
            max-width: 400px;  /* Set custom width */
        }

        /* Make the image inside the modal scale responsively */
        .modal-body {
            text-align: center; /* Center the image */
        }

        .modal-body img {
            max-width: 100%;  /* Make sure image is responsive and scales with the modal size */
            max-height: 300px;  /* Limit the height of the image */
            width: auto;  /* Maintain the aspect ratio */
            height: auto;
        }

        /* Optionally, you can also add a border or other styles to the image */
        .img-container {
            width: 100%;
            overflow: hidden;
            text-align: center;
        }
        
      

    </style>
</head>

<body>
    <!-- Modal Structure -->
    <div class="modal" id="modal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Crop Image</h5>
                </div>
                <div class="modal-body">
                    <div class="img-container">
                        <img id="image" src="" alt="Image to crop">
                    </div>
                     <div class="preview"></div>
                                   
                    
                </div>
                <div class="modal-footer d-flex justify-content-start">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal" onclick="clearFileInput()">Cancel</button>
                    <button type="button" class="btn btn-primary btn-sm" id="crop">Crop</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Include the necessary JS files (for Bootstrap, Cropper, etc.) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="cropperjs/dist/cropper.js"></script>
    <link rel="stylesheet" href="cropperjs/dist/cropper.css">
</body>




    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="sweetalert.js"></script>
<script src="https://cdn.jsdelivr.net/npm/compressorjs@1.1.0/dist/compressor.min.js"></script>
    
    <script>
        function clearFileInput() {
            document.getElementById('imageInput').value = '';
        }


$('form').submit(function(e) {
    e.preventDefault(); // Prevent default form submission
    
    $('#submitButton').hide(); // Hide submit button
    $('#spinnerModal').removeClass('d-none').fadeIn(); // Show spinner with fade-in effect
    
    setTimeout(() => {
        this.submit(); // Trigger form submission after delay or UI transitions
    }, 1000); // Optional delay for smooth transition
});




        // Initialize modal with custom options to prevent closing on outside click
$(document).ready(function() {
    // Modal behavior on open
    $('#modal').modal({
        backdrop: 'static',  // Disables closing the modal when clicking outside
        keyboard: false      // Disables closing the modal when pressing the escape key
    });

    // Handling file input change event
   // File input change event
$("body").on("change", "#imageInput", function(e) {
    var files = e.target.files;
    var file = files[0];

    // Check if the file is of type JPEG, JPG, or PNG
    var fileType = file.type;
    if (fileType != 'image/jpeg' && fileType != 'image/png') {
        swal({
            title: "Alert",
            text: "Please upload a JPEG or PNG image.",
            icon: "error",
        });
        $("#imageInput").val('');  // Clear file input
        return;
    }

    // Check if the file size is greater than 1 MB
    if (file.size > 1024 * 1024*8) {
        swal({
            title: "Alert",
            text: "File size must not be greater than 8 MB.",
            icon: "error",
        });
        $("#imageInput").val('');  // Clear file input
        return;
    }

   // Compress the image using Compressor.js
            new Compressor(file, {
                quality: 0.4,  // Adjust quality to reduce file size
                success(result) {
                    var done = function(url) {
                        image.src = url;
                        $('#modal').modal('show');  // Open modal
                    };

                    // Load the compressed image to the modal
                    if (URL) {
                        done(URL.createObjectURL(result));
                    } else if (FileReader) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            done(reader.result);
                        };
                        reader.readAsDataURL(result);
                    }
                },
                error(err) {
                    console.error(err.message);
                },
            });
       


    // Initialize the cropper when modal is shown
    var cropper;
    var image = document.getElementById('image');
    $('#modal').on('shown.bs.modal', function() {
        cropper = new Cropper(image, {
            aspectRatio: 3.5 / 4.5, // Aspect ratio of the image to crop
            viewMode: 3, // Set to 3 for more control over the image
            preview: '.preview' // Preview the cropped image in the preview box
        });
    });

    // Destroy the cropper when modal is hidden
    $('#modal').on('hidden.bs.modal', function() {
        cropper.destroy();
        cropper = null;
    });

    // Handle the crop button click
    $('#crop').click(function() {
        var canvas;
        canvas = cropper.getCroppedCanvas({
            width: 295,
            height: 394
        });

        canvas.toBlob(function(blob) {
            var reader = new FileReader();
            reader.readAsDataURL(blob);
            reader.onloadend = function() {
                var base64data = reader.result;
                $('#croppedImage').val(base64data); // Set the cropped image to the hidden input
                $('#modal').modal('hide'); // Hide the modal after cropping
            };
        });
    });
});

});
        const districtsKerala = <?php echo json_encode($districts_Kerala); ?>;
        const districtsTamilnadu = <?php echo json_encode($districts_Tamilnadu); ?>;

        function updateDistricts() {
            const state = document.getElementById('state').value;
            const districtSelect = document.getElementById('district');

            districtSelect.innerHTML = '<option value="">Select</option>';

            let districts = [];
            if (state == 'Kerala') {
                districts = districtsKerala;
            } else if (state == 'Tamilnadu') {
                districts = districtsTamilnadu;
            }

            districts.forEach(function(district) {
                const option = document.createElement('option');
                option.value = district;
                option.textContent = district;
                districtSelect.appendChild(option);
            });
        }
    </script>

    <script src="script.js"></script>
</body>
</html>
