<?php
// Prevent access to register.php after 02-07-2025
date_default_timezone_set('Asia/Kolkata');

$cutoffDate = new DateTime('2025-07-02 22:00:00', new DateTimeZone('Asia/Kolkata'));
$today      = new DateTime('now', new DateTimeZone('Asia/Kolkata'));

if ($today > $cutoffDate) {
    // include 'close.php';
    // exit;
}
?>
<!DOCTYPE html>
<html lang="ml">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Vallikkunnu Toppers Meet 2025 🎓</title>
  <link rel="icon" href="download.jpeg" type="image/jpeg">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;500;600&display=swap" rel="stylesheet">
  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)),
                  url('fb1c39f459d6727cb164eb106f3fe298.jpg') no-repeat center center fixed;
      background-size: cover;
      margin: 0;
      padding: 20px;
      color: #f5d774;
    }

    .container {
      max-width: 850px;
      margin: auto;
      background: rgba(0, 0, 0, 0.6);
      backdrop-filter: blur(10px);
      padding: 30px;
      border-radius: 20px;
      box-shadow: 0 8px 24px rgba(255, 215, 0, 0.2);
      border: 1px solid rgba(255, 215, 0, 0.3);
    }

    h2 {
      text-align: center;
      color: #ffd700;
      margin-bottom: 20px;
      text-shadow: 1px 1px 3px rgba(255, 215, 0, 0.6);
    }

    ul {
      padding-left: 20px;
    }

    li {
      margin-bottom: 10px;
      color: #ffecb3;
      font-weight: 300;
    }

    p {
      color: #fffad1;
      font-weight: 400;
    }

    .button-wrapper {
      text-align: center;
      margin-top: 30px;
    }

    button {
      background: linear-gradient(to right, #f5d774, #f1c40f);
      color: #000;
      padding: 12px 30px;
      font-size: 16px;
      font-weight: bold;
      border: none;
      border-radius: 30px;
      cursor: pointer;
      transition: background 0.3s ease;
    }

    button:hover {
      background: linear-gradient(to right, #ffe066, #f5d774);
    }

    footer {
      margin-top: 50px;
      padding: 15px;
      background-color: #f3f3fb;
      text-align: center;
      border-top: 1px solid #ccc;
      border-radius: 0 0 12px 12px;
      font-size: 16px;
      font-weight: bold;
    }

    footer span {
      background: linear-gradient(90deg, #ff6a00, #ee0979, #00c3ff);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      display: inline-block;
      margin-right: 10px;
    }

    footer img {
      height: 40px;
      vertical-align: middle;
    }

    @media (max-width: 600px) {
      .container {
        padding: 20px;
      }

      button {
        width: 100%;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>രജിസ്ട്രേഷൻ നിർദ്ദേശങ്ങൾ</h2>
    <p><strong>ഒരു പ്രാവശ്യം രജിസ്റ്റർ ചെയ്‌താൽ പിന്നീട് രജിസ്റ്റർ ചെയ്യാനോ, എഡിറ്റ്‌ ചെയ്യാനോ സാധിക്കുകയില്ല. അതിനാൽ നിർദ്ദേശങ്ങൾ ശ്രദ്ധയോടെ വായിച്ചു മനസ്സിലാക്കി രജിസ്ട്രേഷൻ നിർവഹിക്കുക.</strong></p>
    <ul>
        <li>ഈ വർഷത്തെ (2025) SSLC, PLUS TWO പരീക്ഷയിൽ മുഴുവൻ വിഷയങ്ങളിലും A+ നേടിയ വള്ളിക്കുന്ന് നിയോജക മണ്ഡലത്തിൽ സ്ഥിര താമസക്കാരായ വിദ്യാർത്ഥികൾ മാത്രം ഈ പരിപാടിയിൽ രജിസ്റ്റർ ചെയ്യണം.</li>
        <li>പേര്, രജിസ്റ്റർ നമ്പർ, മൊബൈൽ നമ്പർ, പഞ്ചായത്ത്, വാർഡ്, സ്കൂളിന്റെ പേര് എന്നിവ കൃത്യമായി രേഖപ്പെടുത്തണം.</li>
                <li>രജിസ്ട്രേഷൻ പൂർത്തീകരിച്ച ശേഷം ലഭിക്കുന്ന അനുമോദന പോസ്റ്റർ ഡൗൺലോഡ് ചെയ്യുകയും അതിലെ ഐഡി നമ്പർ പരിപാടിക്ക് വരുമ്പോൾ കൊണ്ടുവരികയും ചെയ്യുക.</li>
       <li>രജിസ്ട്രേഷൻ അവസാന തീയതി: <strong>2025-ജൂലൈ-23 (ബുധൻ) രാത്രി 12 മണി</strong>.</li>

        <li>വിവരങ്ങൾക്ക് ബന്ധപ്പെടേണ്ട നമ്പർ: <strong>9388123463</strong></li>
    </ul>

    <div class="button-wrapper">
      <form action="register.php" method="post">
        <button type="submit">Proceed</button>
      </form>
    </div>
  </div>

  <footer>
    <span>Powered by</span>
    <a href="https://workmateinfotech.com" target="_blank">
      <img src="https://workmateinfotech.com/images/Workmate_Infotech_Private_Limited____Logo_1_-0_1__1_-removebg-preview%201%20(2).png" alt="Workmate Infotech Logo">
    </a>
  </footer>
</body>
</html>
