<?php
if (!isset($_SESSION)) {
    session_start();
}

require_once('dbclass/dbclass.php');




$id = $_SESSION['user'] ?? 0;

if (empty($_SESSION['user'])) {
    $message = 'No details found';
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
      <meta charset="UTF-8" />
      <script src="sweetalert.js"></script>
    </head>
    <body>
      <script>
        swal({
          title: "Alert",
          text: "<?php echo addslashes($message); ?>",
          icon: "error"
        }).then(function() {
          window.location.href = "https://mlavallikkunnu.in/index.php";
        });
      </script>
    </body>
    </html>
    <?php
    exit;
}


$data = findQuery("SELECT * FROM students WHERE id = $id");

if (!$data || empty($data[0])) {
    $message = 'No details found';
    echo '
    <script src="sweetalert.js"></script>
    <script>
        swal({
            title: "Alert",
            text: "' . addslashes($message) . '",
            icon: "error"
        }).then(function() {
            window.location.href = "https://mlavallikkunnu.in/index.php";
        });
    </script>';
    exit;
}

$student        = $data[0];
$panchayathid   = $student['panchayath'] ?? '';
$datapan        = findQuery("SELECT * FROM panchayath WHERE id = $panchayathid");
$panchayathName = !empty($datapan[0]['panchayath']) ? $datapan[0]['panchayath'] . ' Panchayat' : 'Panchayat';

$image = 'https://mlavallikkunnu.in/' . ($student['photo'] ?? '');
$regno = $student['registrationid'] ?? '';
$name  = $student['name']           ?? '';
$exam  = strtolower($student['exam']) == 'sslc' ? 10 : 12;
?>

<!DOCTYPE html>
<html lang="ml">
<head>
    <meta charset="UTF-8">
   <title>Vallikkunnu Toppers Meet</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="നിങ്ങളുടെ രജിസ്ട്രേഷൻ വിജയകരമായി പൂര്‍ത്തിയായി. അനുമോദന പോസ്റ്റർ ഡൗൺലോഡ് ചെയ്യുക.">
    <link rel="icon" href="download.jpeg">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Malayalam&family=Inter:wght@400;600&display=swap" rel="stylesheet">
    <style>
   body {
    margin: 0;
    padding: 0;
    font-family: 'Inter', 'Noto Sans Malayalam', sans-serif;
     background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)),
                  url('fb1c39f459d6727cb164eb106f3fe298.jpg') no-repeat center center fixed;
    background-size: 400% 400%;
    animation: gradientBG 15s ease infinite;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
     color: #f5d774;
}

 body {
      
      background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)),
                  url('fb1c39f459d6727cb164eb106f3fe298.jpg') no-repeat center center fixed;
      background-size: cover;
      margin: 0;
      padding: 20px;
      color: #f5d774;
    }

    .container {
        background: #fff;
        padding: 30px;
        max-width: 550px;
        width: 90%;
        text-align: center;
        box-shadow: 0 8px 20px rgba(0,0,0,0.1);
        border-radius: 16px;
        transition: 0.3s ease;
    }

    .container:hover {
        transform: scale(1.01);
    }

    .icon {
        width: 90px;
        margin-bottom: 20px;
        animation: pop 0.8s ease;
    }

    @keyframes pop {
        0% { transform: scale(0.5); opacity: 0; }
        100% { transform: scale(1); opacity: 1; }
    }

    h2 {
        color: #3c3c7c;
        margin-bottom: 12px;
        font-size: 22px;
    }

    p {
        font-size: 15px;
        color: #333;
        line-height: 1.6;
    }

    .download-btn {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 20px;
        background: linear-gradient(to right, #f5d774, #f1c40f);
        color: #000;
        font-size: 16px;
        font-weight: bold;
        text-decoration: none;
        border: none;
        border-radius: 10px;
        transition: background 0.3s ease, transform 0.2s ease;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    }

    .download-btn:hover {
        background: linear-gradient(to right, #ffe066, #f5d774);
        transform: translateY(-2px);
    }

    .download-btn:active {
        transform: scale(0.98);
    }

    footer {
        margin-top: 50px;
        padding: 15px;
        background-color: #f3f3fb;
        text-align: center;
        border-top: 1px solid #ccc;
        border-radius: 0 0 12px 12px;
        font-size: 16px;
        font-weight: bold;
    }

    footer span {
        background: linear-gradient(90deg, #ff6a00, #ee0979, #00c3ff);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        display: inline-block;
        margin-right: 10px;
    }

    footer img {
        height: 40px;
        vertical-align: middle;
    }
</style>

</head>
<body>
    <div class="container">
        <img src="image.png" alt="Success Icon" class="icon">
        <h2>താങ്കളുടെ രജിസ്ട്രേഷൻ വിജയകരമായി പൂര്‍ത്തിയായി</h2>
        <p>നിങ്ങൾക്ക് ലഭിക്കുന്ന അനുമോദന പോസ്റ്റർ ഡൌൺലോഡ് ചെയ്യുകയും<br> അതിലെ ഐഡി നമ്പർ പരിപാടിക്ക് വരുമ്പോൾ കൊണ്ട് വരികയും ചെയ്യുക.</p>

        <a class="download-btn"
           href="generate_poster.php?name=<?= urlencode(htmlspecialchars($name)); ?>&regno=<?= urlencode(htmlspecialchars($regno)); ?>&exam=<?= $exam; ?>&panchayath=<?= urlencode(htmlspecialchars($panchayathName)); ?>&image=<?= urlencode(htmlspecialchars($image)); ?>"
           download="poster.jpg">
            
            പോസ്റ്റർ ഡൗൺലോഡ് ചെയ്യുക
        </a>
           <footer style="
  margin-top: 50px;
  padding: 15px;
  background-color: #f3f3fb;
  text-align: center;
  border-top: 1px solid #ccc;
  border-radius: 0 0 12px 12px;
  font-size: 16px;
  font-weight: bold;
">
  <span style="background: linear-gradient(90deg, #ff6a00, #ee0979, #00c3ff);
               -webkit-background-clip: text;
               -webkit-text-fill-color: transparent;
               display: inline-block;
               margin-right: 10px;">
    Powered by
  </span>
  <a href="https://workmateinfotech.com" target="_blank" style="display: inline-block; vertical-align: middle;">
    <img src="https://workmateinfotech.com/images/Workmate_Infotech_Private_Limited____Logo_1_-0_1__1_-removebg-preview%201%20(2).png" alt="Workmate Infotech Logo" style="height: 40px; vertical-align: middle;">
  </a>
</footer>
    </div>
    
    
 
</body>
</html>
