<?php
// Database connection (MySQLi)
$conn = new mysqli('localhost', 'gdhhsxmy_mlavallikkunnu', 'mlavallikkunnu', 'gdhhsxmy_mlavallikkunnu');

if ($conn->connect_error) {
    die('Connection failed: ' . $conn->connect_error);
}

// Pagination setup
$limit  = 20; // cards per page
$page   = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;

// Total count
$result     = $conn->query('SELECT COUNT(*) AS total FROM survey_responses where status=0');
$rowCount   = $result->fetch_assoc();
$total      = $rowCount['total'];
$totalPages = ceil($total / $limit);

// Fetch main responses
$stmt = $conn->prepare('SELECT * FROM survey_responses where status=0 ORDER BY id DESC LIMIT ?, ?');
$stmt->bind_param('ii', $offset, $limit);
$stmt->execute();
$responses = $stmt->get_result();

// Function to fetch related data
function fetchRelated($conn, $table, $field, $response_id)
{
    $stmt = $conn->prepare("SELECT $field FROM $table WHERE response_id = ?");
    $stmt->bind_param('i', $response_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $values = [];
    while ($row = $result->fetch_assoc()) {
        $values[] = $row[$field];
    }

    return $values;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Survey Responses</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    body {
        background-color: #fff;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .card {
        border: 1px solid #f1c40f;
        box-shadow: 0 2px 5px rgba(0,0,0,0.05);
        border-radius: 8px;
        font-size: 0.85rem; /* smaller text */
    }
    .card-header {
        background-color: #f1c40f;
        font-weight: bold;
        color: #000;
        border-bottom: none;
        padding: 6px 10px;
        font-size: 0.9rem;
    }
    .card-body {
        padding: 8px 10px;
    }
    .card-body p {
        margin-bottom: 4px;
    }
    .card-footer {
        padding: 6px 10px;
    }
    .btn-gold {
        background-color: #f1c40f;
        color: #000;
        font-weight: bold;
        border: none;
        font-size: 0.8rem;
        padding: 4px 8px;
    }
    .btn-gold:hover {
        background-color: #d4ac0d;
    }
    .btn-sm {
        font-size: 0.75rem;
        padding: 3px 6px;
    }
</style>
</head>
<body>

<div class="container my-4">
    <h2 class="text-center mb-4">Survey Responses</h2>
    <div class="row g-3">
        <?php while ($row = $responses->fetch_assoc()): ?>
            <?php
            $subjects = fetchRelated($conn, 'survey_subjects', 'subject_name', $row['id']);
            $careers  = fetchRelated($conn, 'survey_careers', 'career_name', $row['id']);
            $learning = fetchRelated($conn, 'survey_learning', 'learning_item', $row['id']);
            ?>
            <div class="col-12 col-sm-6 col-md-3">
                <div class="card h-100">
                    <div class="card-header">
                        <?= htmlspecialchars($row['full_name']) ?> (<?= htmlspecialchars($row['age']) ?>)
                    </div>
                    <div class="card-body">
                        <p><strong>Gender:</strong> <?= htmlspecialchars($row['gender']) ?></p>
                        <p><strong>School:</strong> <?= htmlspecialchars($row['school_name']) ?></p>
                        <p><strong>Class:</strong> <?= htmlspecialchars($row['class_completed']) ?></p>
                        <p><strong>Stream:</strong> <?= htmlspecialchars($row['stream_interest']) ?></p>
                        <p><strong>Subjects:</strong> <?= htmlspecialchars(implode(', ', $subjects)) ?></p>
                        <p><strong>Careers:</strong> <?= htmlspecialchars(implode(', ', $careers)) ?></p>
                        <p><strong>Learning:</strong> <?= htmlspecialchars(implode(', ', $learning)) ?></p>
                    </div>
                    <div class="card-footer text-center">
                        <a href="register.php?id=<?= $row['id'] ?>" class="btn btn-gold btn-sm">Edit</a>
                        <a href="delete.php?id=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete this response?')">Delete</a>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
    </div>

    <!-- Pagination -->
    <nav class="mt-3">
        <ul class="pagination justify-content-center pagination-sm">
            <?php if ($page > 1): ?>
                <li class="page-item"><a class="page-link" href="?page=<?= $page - 1 ?>">Previous</a></li>
            <?php endif; ?>
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <li class="page-item <?= $i == $page ? 'active' : '' ?>">
                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>
            <?php if ($page < $totalPages): ?>
                <li class="page-item"><a class="page-link" href="?page=<?= $page + 1 ?>">Next</a></li>
            <?php endif; ?>
        </ul>
    </nav>
</div>

</body>
</html>
