<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Max-Age: 1000');
header('Access-Control-Allow-Headers: Content-Type');
require_once('../lib/dbclass.php');

extract($_POST);
$data = $_REQUEST;





function hashCalculate($salt, $input)
{
    /* Columns used for hash calculation, Donot add or remove values from $hash_columns array */
    $hash_columns = ['address_line_1', 'address_line_2', 'amount', 'api_key', 'city', 'country', 'currency', 'description', 'email', 'mode', 'name', 'order_id', 'phone', 'return_url', 'state', 'udf1', 'udf2', 'udf3', 'udf4', 'udf5', 'zip_code',];
    /*Sort the array before hashing*/
    sort($hash_columns);

    /*Create a | (pipe) separated string of all the $input values which are available in $hash_columns*/
    $hash_data = $salt;

    foreach ($hash_columns as $column) {
        if (isset($input[$column])) {
            if (strlen($input[$column]) > 0) {
                $hash_data .= '|' . trim($input[$column]);
            }
        }
    }

    $hash = strtoupper(hash('sha512', $hash_data));

    return $hash;
}







function api_call($final_data, $order_id)
{
    // URL to send the POST request to
    $url = 'https://pgbiz.omniware.in/v2/paymentstatus';

    // Data to send in the POST request
    $data = [
        'hash'     => $final_data,
        'api_key'  => APIKEY, // from DBClass
        'order_id' => $order_id,
    ];

    // Initialize cURL session
    $ch = curl_init();

    // Set cURL options for POST request
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);  // Set method to POST
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));  // Send data in POST body
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);  // To return the response as a string

    // Execute the cURL request and get the response
    $result = curl_exec($ch);



    // Check for errors
    if (curl_errno($ch)) {
        //echo 'Curl error: ' . curl_error($ch);
    } else {
        // Process the response (e.g., decode JSON if it's JSON formatted)
        //echo "Response from the server: " . $response;
    }

    // Close the cURL session
    curl_close($ch);



    // Decode the JSON data into a PHP associative array
    $data = json_decode($result, true);

    // Access the response_message from the first item in the "data" array
    $response_message = $data['data'][0]['response_message'];

    $message = 'false';


    if ($response_message == 'SUCCESS') {
        if ($data['data'][0]['bank_ref_id'] != '') {
            $Transaction_id = $data['data'][0]['bank_ref_id'];
        } else {
            $Transaction_id = $data['data'][0]['transaction_id'];
        }
        $order_id        = $data['data'][0]['order_id'];
        $order_time      = new DateTime($data['data'][0]['payment_datetime']);
        $order_date_time = $order_time->format('Y-m-d H:i:s');

        // Update query
        updateQuery("UPDATE tbl_transaction 
                         SET Transid='$Transaction_id', 
                             Received=Amount, 
                             is_Razor_payment_gateway=2, 
                             dateadded='$order_date_time' 
                         WHERE orderid='$order_id'");
        $message = 'true';
    } else {
        $message = 'false';
    }

    echo json_encode(['Status' => $message, 'data' => []]);

    return;
}





$salt    = SALT; // from DBClass
$api_key = APIKEY; //from DBClass


$order_id      = $_REQUEST['order_id'];
$pendingorders = ['order_id' => $order_id,'api_key' => $api_key];
$hash          = hashCalculate($salt, $pendingorders);
$pendingorders = $hash;
api_call($pendingorders, $order_id);


















?>	   


